; 8051 standard built-in register names

; byte SFRs

P0	EQU	80H
SP	EQU	81H
DPL	EQU	82H
DPH	EQU	83H
ADAT	EQU	84H
;	EQU	85H
;	EQU	86H
PCON	EQU	87H

TCON	EQU	88H
TMOD	EQU	89H
TL0	EQU	8AH
TL1	EQU	8BH
TH0	EQU	8CH
TH1	EQU	8DH
PWCM	EQU	8EH
PWMP	EQU	8FH

P1	EQU	90H
;91..97

SCON	EQU	98H
SBUF	EQU	99H
;9A..9F

P2	EQU	0A0H
;A1..A7

IE	EQU	0A8H
CML0	EQU	0A9H
CML1	EQU	0AAH
CML2	EQU	0ABH
CTL0	EQU	0ACH
CTL1	EQU	0ADH
CTL2	EQU	0AEH
CTL3	EQU	0AFH

P3	EQU	0B0H
;B1..B7

IP	EQU	0B8H
;B9..BF

PR	EQU	0C0H
;	EQU	0C1H
;	EQU	0C2H
;	EQU	0C3H
P5	EQU	0C4H
ADCON	EQU	0C5H
ADCH	EQU	0C6H
;	EQU	0C7H

T2CON	EQU	0C8H
CMH0	EQU	0C9H
RCAP2L	EQU	0CAH
RCAP2H	EQU	0CBH
TL2	EQU	0CCH
TH2	EQU	0CDH
CTH2	EQU	0CEH
CTH3	EQU	0CFH

PSW	EQU	0D0H
;D1..D7

I2CFG	EQU	0D8H
S1STA	EQU	0D9H
S1DAT	EQU	0DAH
S1ADR	EQU	0DBH
;DC..DF

ACC	EQU	0E0H
;E1..E7

CSR	EQU	0E8H
;	EQU	0E9H
TN2CON	EQU	0EAH
CTCON	EQU	0EBH
TML2	EQU	0ECH
TMH2	EQU	0EDH
STE	EQU	0EEH
RTE	EQU	0EFH

B	EQU	0F0H
;F1..F7

I2STA	EQU	0F8H
;	EQU	0F9H
;	EQU	0FAH
;	EQU	0FBH
PWM0	EQU	0FCH
PWM1	EQU	0FDH
PWENA	EQU	0FEH
T3	EQU	0FFH

; bit SFRs

;P0		80-87

IT0	EQU	88H.0
IE0	EQU	88H.1
IT1	EQU	88H.2
IE1	EQU	88H.3
TR0	EQU	88H.4
TF0	EQU	88H.5
TR1	EQU	88H.6
TF1	EQU	88H.7

;P1		90-97

RI	EQU	98H.0
TI	EQU	98H.1
RB8	EQU	98H.2
TB8	EQU	98H.3
REN	EQU	98H.4
SM2	EQU	98H.5
SM1	EQU	98H.6
SM0	EQU	98H.7

;P2		A0-A7

EX0	EQU	0A8H.0
ET0	EQU	0A8H.1
EX1	EQU	0A8H.2
ET1	EQU	0A8H.3
ES	EQU	0A8H.4
;	EQU	0A8H.5	; IE.5
;	EQU	0A8H.6	; IE.6
EA	EQU	0A8H.7

RXD	EQU	0B0H.0
TXD	EQU	0B0H.1
INT0	EQU	0B0H.2
INT1	EQU	0B0H.3
T0	EQU	0B0H.4
T1	EQU	0B0H.5
WR	EQU	0B0H.6
RD	EQU	0B0H.7

PX0	EQU	0B8H.0
PT0	EQU	0B8H.1
PX1	EQU	0B8H.2
PT1	EQU	0B8H.3
PS	EQU	0B8H.4
;	EQU	0B8H.5	; IP.5
;	EQU	0B8H.6	; IP.6
;	EQU	0B8H.7	; IP.7

;P4		C0..C7

CPRL2	EQU	0C8H.0
CT2	EQU	0C8H.1
TR2	EQU	0C8H.2
EXEN2	EQU	0C8H.3
TCLK	EQU	0C8H.4
RCLK	EQU	0C8H.5
EXF2	EQU	0C8H.6
TF2	EQU	0C8H.7

P	EQU	0D0H.0
;	EQU	0D0H.1	; PSW.1
OV	EQU	0D0H.2
RS0	EQU	0D0H.3
RS1	EQU	0D0H.4
F0	EQU	0D0H.5
AC	EQU	0D0H.6
CY	EQU	0D0H.7

CT0	EQU	0D8H.0
CT1	EQU	0D8H.1
;	EQU	0D8H.2	; I2CFG.2
;	EQU	0D8H.3	; I2CFG.3
TIRUN	EQU	0D8H.4
CLRTI	EQU	0D8H.5
MASTRQ	EQU	0D8H.6
SLAVEN	EQU	0D8H.7

;ACC		E0..E7

IBF	EQU	0E8H.0
OBF	EQU	0E8H.1
IDSM	EQU	0E8H.2
OBFC	EQU	0E8H.3
MA0	EQU	0E8H.4
MA1	EQU	0E8H.5
MB0	EQU	0E8H.6
MB1	EQU	0E8H.7

;B		F0.F7

XSTP	EQU	0F8H.0
SXTR	EQU	0F8H.1
MAKSTP	EQU	0F8H.2
MKSTR	EQU	0F8H.3
XACTV	EQU	0F8H.4
XDATA	EQU	0F8H.5
IDLE	EQU	0F8H.6
;	EQU	0F8H.7	; I2STA.7


; IRQs
;IE0	EQU	0003H
;TF0	EQU	000BH
;IE1	EQU	0013H
;TF1	EQU	001BH
;RI_TI	EQU	0023H
;TF2_EXF2 EQU	002BH
